unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, mysql80conn, mysql55conn, SQLDB, DB, simpleipc, Forms,
  Controls, Graphics, Dialogs, StdCtrls, DBGrids, ExtCtrls, DBCtrls,
  ButtonPanel, IpFileBroker, IpHtml, TASources, Math;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    ButtonPanel1: TButtonPanel;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DBGrid3: TDBGrid;
    DBText1: TDBText;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MySQL55Connection1: TMySQL55Connection;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    SQLQuery1: TSQLQuery;
    SQLQuery1H_Ulica: TFloatField;
    SQLQuery1PowerHeater: TLongintField;
    SQLQuery1PowerWater: TLongintField;
    SQLQuery1PR_KEY: TLargeintField;
    SQLQuery1P_Ulica: TFloatField;
    SQLQuery1S_Floor_H: TFloatField;
    SQLQuery1S_Floor_P: TFloatField;
    SQLQuery1S_Floor_T: TFloatField;
    SQLQuery1S_Floor_T_Bat: TFloatField;
    SQLQuery1T_Sauna: TFloatField;
    SQLQuery1T_Sauna_Cel: TLongintField;
    SQLQuery1T_Ulica: TFloatField;
    SQLQuery1Vremya: TDateTimeField;
    SQLTransaction1: TSQLTransaction;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure DBTextClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private

  public

  end;

var
  Door_Ser, Door_Kab: integer;
  T_Bat_Min, T_Bat_Max, T_Bat_Curr        : double;
  Form1: TForm1;

implementation
  Uses MMSystem, LCLProc, Unit2;
{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
  if (Timer1.Enabled = false) then
  begin
    Button1.Caption:='Остановить';
    SQLTransaction1.Active:=true;
    Timer1.Enabled:=true;
  end
  else
  begin
    Button1.Caption:='Поехали';
    SQLTransaction1.Active:=false;
    Timer1.Enabled:=false;
  end;
end;

procedure TForm1.DBTextClick(Sender: TObject);
begin
  if (Sender is TDBText) then
  begin
    Form2.DBText1.DataField:='';
    Form2.DBText1.DataSource:=(Sender as TDBText).DataSource;
    Form2.DBText1.DataField:= (Sender as TDBText).DataField;
    Form2.Show;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  Form2.Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Door_Ser:=0;
  Door_Kab:=0;
  T_Bat_Min:=100.0;
  T_Bat_Max:=-100.0;
  T_Bat_Curr:=-100;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  T_Bat,Delta_T_Bat      : double;
begin
  SQLQuery1.Close;
  SQLTransaction1.Commit;                      // Типа - чистим кэш?
  SQLQuery1.Open;

  Caption:='Монитор. (С) Uchvatov.A. (v)01/10/2025 | '+DateTimeToStr(Now);

  T_Bat:=SQLQuery1.FieldByName('S_Floor_T_Bat').AsFloat;

  if (T_Bat_Curr<>-100.0) then
  begin
    Delta_T_Bat:=RoundTo(T_Bat-T_Bat_Curr, -2);
    if (Delta_T_Bat<>0.0) then
    begin
      if (Delta_T_Bat>0) then
      begin
        Label3.Font.Color:=clRed;
        Label3.Caption:='Дельта Т: '+FloatToStr(Delta_T_Bat)+'. Батарея греется'
      end
      else
      begin
        Label3.Font.Color:=clBlue;
        Label3.Caption:='Дельта Т: '+FloatToStr(Delta_T_Bat)+'. Батарея остывает'
      end;
    end;
  end
  else
  begin
    Label3.Caption:='Дельта Т: не определена пока еще :)';
  end;
  T_Bat_Curr:=T_Bat;

  if (T_Bat_Min>T_bat) and (T_Bat<>-100.0) then
    T_Bat_Min:=T_Bat;
  if (T_Bat_Max<T_bat) then
    T_Bat_Max:=T_Bat;
  Label1.Caption:='Минимальная Т батареи: '+FloatToStr(T_Bat_Min);
  Label2.Caption:='Максимальная Т батареи: '+FloatToStr(T_Bat_Max);
  Label4.Caption:='Текущая Т батареи: '+SQLQuery1.FieldByName('S_Floor_T_Bat').AsString;
end;

end.

